<?php
/**
 * @file
 * Contains default views on behalf of the comment module.
 */

/**
 * Implementation of hook_views_default_views().
 */
function comment_views_default_views() {
  $view = new view;
  $view->name = 'comments_recent';
  $view->description = 'Contains a block and a page to list recent comments; the block will automatically link to the page, which displays the comment body as well as a link to the node.';
  $view->tag = 'default';
  $view->base_table = 'comments';
  $view->human_name = 'Recent comments';
  $view->api_version = 2;
  $view->disabled = TRUE; /* Edit this to true to make a default view disabled initially */
  $handler = $view->new_display('default', 'Defaults', 'default');
  $handler->override_option('relationships', array(
    'nid' => array(
      'id' => 'nid',
      'table' => 'comments',
      'field' => 'nid',
      'label' => 'Node',
      'required' => FALSE,
    ),
  ));
  $handler->override_option('fields', array(
    'subject' => array(
      'id' => 'subject',
      'table' => 'comments',
      'field' => 'subject',
      'label' => '',
      'link_to_comment' => 1,
      'relationship' => 'none',
    ),
    'timestamp' => array(
      'id' => 'timestamp',
      'table' => 'comments',
      'field' => 'timestamp',
      'label' => '',
      'date_format' => 'time ago',
      'custom_date_format' => '',
      'relationship' => 'none',
    ),
  ));
  $handler->override_option('sorts', array(
    'timestamp' => array(
      'id' => 'timestamp',
      'table' => 'comments',
      'field' => 'timestamp',
      'order' => 'DESC',
      'granularity' => 'second',
      'relationship' => 'none',
    ),
  ));
  $handler->override_option('filters', array(
    'status_extra' => array(
      'id' => 'status_extra',
      'table' => 'node',
      'field' => 'status_extra',
      'operator' => '=',
      'value' => '',
      'group' => 0,
      'exposed' => FALSE,
      'expose' => array(
        'operator' => FALSE,
        'label' => '',
      ),
      'relationship' => 'nid',
    ),
  ));
  $handler->override_option('access', array(
    'type' => 'perm',
    'role' => array(),
    'perm' => 'access comments',
  ));
  $handler->override_option('title', 'Recent comments');
  $handler->override_option('items_per_page', 5);
  $handler->override_option('use_more', 1);
  $handler->override_option('style_plugin', 'list');
  $handler->override_option('style_options', array(
    'type' => 'ul',
  ));
  $handler = $view->new_display('page', 'Page', 'page');
  $handler->override_option('fields', array(
    'title' => array(
      'id' => 'title',
      'table' => 'node',
      'field' => 'title',
      'label' => 'Reply to',
      'relationship' => 'nid',
      'link_to_node' => 1,
    ),
    'timestamp' => array(
      'id' => 'timestamp',
      'table' => 'comments',
      'field' => 'timestamp',
      'label' => '',
      'date_format' => 'time ago',
      'custom_date_format' => '',
      'relationship' => 'none',
    ),
    'subject' => array(
      'id' => 'subject',
      'table' => 'comments',
      'field' => 'subject',
      'label' => '',
      'link_to_comment' => 1,
      'relationship' => 'none',
    ),
    'comment' => array(
      'id' => 'comment',
      'table' => 'comments',
      'field' => 'comment',
      'label' => '',
      'relationship' => 'none',
    ),
  ));
  $handler->override_option('items_per_page', 25);
  $handler->override_option('use_pager', '1');
  $handler->override_option('row_options', array(
    'inline' => array(
      'title' => 'title',
      'timestamp' => 'timestamp',
    ),
    'separator' => '&nbsp;',
  ));
  $handler->override_option('path', 'comments/recent');
  $handler->override_option('menu', array(
    'type' => 'none',
    'title' => '',
    'weight' => 0,
  ));
  $handler->override_option('tab_options', array(
    'type' => 'none',
    'title' => '',
    'weight' => 0,
  ));
  $handler = $view->new_display('block', 'Block', 'block');
  $views[$view->name] = $view;

  $view = new view;
  $view->name = 'tracker';
  $view->description = 'Shows all new activity on system.';
  $view->tag = 'default';
  $view->base_table = 'node';
  $view->human_name = 'Tracker';
  $view->api_version = 2;
  $view->disabled = TRUE; /* Edit this to true to make a default view disabled initially */
  $handler = $view->new_display('default', 'Defaults', 'default');
  $handler->override_option('fields', array(
    'type' => array(
      'id' => 'type',
      'table' => 'node',
      'field' => 'type',
      'label' => 'Type',
    ),
    'title' => array(
      'id' => 'title',
      'table' => 'node',
      'field' => 'title',
      'label' => 'Title',
      'link_to_node' => TRUE,
    ),
    'name' => array(
      'id' => 'name',
      'table' => 'users',
      'field' => 'name',
      'label' => 'Author',
      'link_to_user' => TRUE,
    ),
    'comment_count' => array(
      'id' => 'comment_count',
      'table' => 'node_comment_statistics',
      'field' => 'comment_count',
      'label' => 'Replies',
      'set_precision' => FALSE,
      'precision' => 0,
      'decimal' => '.',
      'separator' => ',',
      'prefix' => '',
      'suffix' => '',
    ),
    'last_comment_timestamp' => array(
      'id' => 'last_comment_timestamp',
      'table' => 'node_comment_statistics',
      'field' => 'last_comment_timestamp',
      'label' => 'Last Post',
      'date_format' => 'small',
      'custom_date_format' => '',
    ),
    'timestamp' => array(
      'id' => 'timestamp',
      'table' => 'history_user',
      'field' => 'timestamp',
      'label' => '',
      'comments' => 1,
      'relationship' => 'none',
      'link_to_node' => 0,
      'comment' => 1,
    ),
    'new_comments' => array(
      'id' => 'new_comments',
      'table' => 'node',
      'field' => 'new_comments',
      'label' => '',
      'set_precision' => FALSE,
      'precision' => 0,
      'decimal' => '.',
      'separator' => ',',
      'prefix' => '',
      'suffix' => ' new',
      'link_to_comment' => 1,
      'no_empty' => 1,
      'relationship' => 'none',
    ),
  ));
  $handler->override_option('sorts', array(
    'last_comment_timestamp' => array(
      'id' => 'last_comment_timestamp',
      'table' => 'node_comment_statistics',
      'field' => 'last_comment_timestamp',
      'order' => 'ASC',
      'granularity' => 'second',
    ),
  ));
  $handler->override_option('arguments', array(
    'uid_touch' => array(
      'id' => 'uid_touch',
      'table' => 'node',
      'field' => 'uid_touch',
      'default_action' => 'ignore',
      'style_plugin' => 'default_summary',
      'style_options' => array(
        'count' => TRUE,
        'override' => FALSE,
        'items_per_page' => 25,
      ),
      'wildcard' => 'all',
      'wildcard_substitution' => 'All',
      'title' => 'Recent posts for %1',
      'default_argument_type' => 'fixed',
      'default_argument' => '',
      'validate_type' => 'none',
      'validate_fail' => 'not found',
      'relationship' => 'none',
      'default_argument_fixed' => '',
      'default_argument_php' => '',
      'validate_argument_node_type' => array(
        'album' => 0,
        'artist' => 0,
        'book' => 0,
        'page' => 0,
        'story' => 0,
        'track' => 0,
      ),
      'validate_argument_php' => '',
    ),
  ));
  $handler->override_option('filters', array(
    'status' => array(
      'id' => 'status',
      'table' => 'node',
      'field' => 'status',
      'operator' => '=',
      'value' => '1',
      'group' => 0,
      'exposed' => FALSE,
      'expose' => array(
        'operator' => FALSE,
        'label' => '',
      ),
      'status' => array(
        'id' => 'status',
        'table' => 'comments',
        'field' => 'status',
        'operator' => '=',
        'value' => 0,
        'group' => 0,
        'exposed' => FALSE,
        'expose' => array(
          'operator' => FALSE,
          'label' => '',
        ),
        'relationship' => 'none',
      ),
    ),
  ));
  $handler->override_option('access', array(
    'type' => 'perm',
    'role' => array(),
    'perm' => 'access content',
  ));
  $handler->override_option('title', 'Recent posts');
  $handler->override_option('items_per_page', '25');
  $handler->override_option('use_pager', TRUE);
  $handler->override_option('style_plugin', 'table');
  $handler->override_option('style_options', array(
    'override' => 1,
    'order' => 'desc',
    'columns' => array(
      'type' => 'type',
      'title' => 'title',
      'name' => 'name',
      'comment_count' => 'comment_count',
      'last_comment_timestamp' => 'last_comment_timestamp',
      'timestamp' => 'title',
      'new_comments' => 'comment_count',
    ),
    'info' => array(
      'type' => array(
        'sortable' => 1,
        'separator' => '',
      ),
      'title' => array(
        'sortable' => 1,
        'separator' => '&nbsp;',
      ),
      'name' => array(
        'sortable' => 1,
        'separator' => '',
      ),
      'comment_count' => array(
        'sortable' => 1,
        'separator' => '<br />',
      ),
      'last_comment_timestamp' => array(
        'sortable' => 1,
        'separator' => '&nbsp;',
      ),
      'timestamp' => array(
        'separator' => '',
      ),
      'new_comments' => array(
        'separator' => '',
      ),
    ),
    'default' => 'last_comment_timestamp',
  ));
  $handler = $view->new_display('page', 'Page', 'page');
  $handler->override_option('path', 'tracker');
  $handler->override_option('menu', array(
    'type' => 'normal',
    'title' => 'Recent posts',
    'weight' => 0,
  ));
  $handler->override_option('tab_options', array(
    'type' => 'none',
    'title' => NULL,
    'weight' => NULL,
  ));
  $views[$view->name] = $view;

  return $views;
}
